DECLARE @MESSAGE_ID int
DECLARE @SETTING_ID int
DECLARE @ARCHIVE_AGE int
DECLARE @NEXT_EXECUTION_DATE date 
DECLARE @LAST_EXECUTION_DATE date 
DECLARE @TODAY date
DECLARE @FREQUENCY varchar(200)
DECLARE @LAST_EXECUTION_TIME bigint

--get archive setup from DB
SELECT TOP 1 @SETTING_ID = id, @FREQUENCY = frequency, @ARCHIVE_AGE = archive_age, @LAST_EXECUTION_TIME = last_execution_time FROM direct.dbo.archive_settings 
--get last execution date
SELECT TOP 1 @LAST_EXECUTION_DATE = DATEADD(second, @LAST_EXECUTION_TIME, '19700101')
SELECT @TODAY= DATEADD(dd, 0, DATEDIFF(dd, 0, CURRENT_TIMESTAMP))

--get next execution date
IF @FREQUENCY = 'daily'
BEGIN
	SELECT @NEXT_EXECUTION_DATE = DATEADD(dd, 1, @LAST_EXECUTION_DATE)
END
ELSE IF @FREQUENCY = 'weekly'
BEGIN
	SELECT @NEXT_EXECUTION_DATE = DATEADD(dd, 7, @LAST_EXECUTION_DATE)
END
ELSE IF @FREQUENCY = 'biweekly'
BEGIN
	SELECT @NEXT_EXECUTION_DATE = DATEADD(dd, 14, @LAST_EXECUTION_DATE)
END
ELSE IF @FREQUENCY = 'monthly'
BEGIN
	SELECT @NEXT_EXECUTION_DATE = DATEADD(mm, 1, @LAST_EXECUTION_DATE)
END
ELSE IF @FREQUENCY = 'bimonthly'
BEGIN
	SELECT @NEXT_EXECUTION_DATE = DATEADD(mm, 2, @LAST_EXECUTION_DATE)
END
ELSE IF @FREQUENCY = 'six_months'
BEGIN
	SELECT @NEXT_EXECUTION_DATE = DATEADD(mm, 6, @LAST_EXECUTION_DATE)
END
ELSE
	SELECT @NEXT_EXECUTION_DATE = DATEADD(yy, 1, @LAST_EXECUTION_DATE)

IF @TODAY >= @NEXT_EXECUTION_DATE
BEGIN
	WHILE (SELECT Count(*) FROM mail.dbo.messages 
	WHERE timestamp <= DATEDIFF(second, '19700101', DATEADD(day, 0 - @ARCHIVE_AGE, GETDATE())) 
	AND archived != 1 
	AND (draft = 1 OR sent = 1 OR (sent = 0 AND draft = 0))
	AND mailbox_id IN (SELECT id FROM mail.dbo.mailboxes WHERE name IN (SELECT user_name FROM direct.dbo.users))) > 0

	BEGIN
		SELECT TOP 1 @MESSAGE_ID = id FROM mail.dbo.messages 
		WHERE timestamp <= DATEDIFF(second, '19700101', DATEADD(day, 0 - @ARCHIVE_AGE, getdate())) 
		AND archived != 1 
		AND (draft = 1 OR sent = 1 OR (sent = 0 AND draft = 0))
		AND mailbox_id IN (SELECT id FROM mail.dbo.mailboxes WHERE name IN (SELECT user_name FROM direct.dbo.users))
		--archive message
		UPDATE mail.dbo.messages SET archived = 1 WHERE id = @MESSAGE_ID 
	END
	--update last execution time
	UPDATE direct.dbo.archive_settings SET last_execution_time = DATEDIFF(second, '19700101', GETDATE()) WHERE id = @SETTING_ID 
END
